using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_page : System.Web.UI.Page
{
    protected void Page_Load(object sender, System.EventArgs e)
    {

        // Execute this code if the page load not is a post back.
        if (!Page.IsPostBack)
        {
            // We check to see if there exists an FormAuthenticationTicket for the user
            // and redirect the user to "Sign-in-form" if this ticket doesnt exist.
            if (Request.IsAuthenticated == false)
            {
                Response.Redirect("Sign-in-form.aspx");
            }
            else
            {
                // This variables are declared so that we can get information from 
                // the FormsAuthenticationTicket.
                FormsIdentity id = (FormsIdentity)User.Identity;
                FormsAuthenticationTicket ticket = id.Ticket;

                // We check if the users are an admin and if the user not is an admin
                // he are redirected to the "Sign-in-form.aspx".
                if (Convert.ToBoolean(ticket.UserData) == false)
                {
                    Response.Redirect("Sign-in-form.aspx");
                }
                else
                {
                    // This is information from the FormsAuthenticationTicket
                    lblUsername.Text = ticket.Name;
                    lblCookiePath.Text = ticket.CookiePath;
                    lblExpireDate.Text = ticket.Expiration.ToString();
                    lblExpired.Text = ticket.Expired.ToString();
                    lblIsPersistent.Text = ticket.IsPersistent.ToString();
                    lblIssueDate.Text = ticket.IssueDate.ToString();
                    lblVersion.Text = ticket.Version.ToString();
                    lblAdmin.Text = ticket.UserData;
                }
            }
        }
    }

    protected void btnSignOut_Click(object sender, System.EventArgs e)
    {
        // This code is executed when the user clicks the "Sign out" button and deletes the cookie and the ticket
        // for the user.
        FormsAuthentication.SignOut();
        Session.Abandon();
        FormsAuthentication.RedirectToLoginPage();
    }
}
